@extends('layouts.agent')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    .zindex-dropdown {
        z-index: 1000;
    }
</style>
@endpush
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
        $steps = [
        1 => 'Basic Details',
        2 => 'Property Details',
        3 => 'Location Details',
        4 => 'Photos & Videos',
        ];
        $currentStep = request()->route()->getName();
        preg_match('/step_(\d+)/', $currentStep, $matches);
        $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
            <div class="step-item">
                <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                    {{ $step }}
                </a>
                <span class="step-label">{{ $label }}</span>
                @if ($step < count($steps))
                    <div class="step-line">
            </div>
            @endif
        </div>
        @endforeach
    </div>
</div>
</div>
<div class="row justify-content-center mt-3">
    <div class="card p-4 col-md-12">
        <form id="addressForm"
            action="{{ isset($property->id) ? route('agent.properties.store_step_3', ['id' => $property->id]) : route('agent.properties.store_step_3') }}"
            method="POST">
            {{ csrf_field() }}
            <div class="mb-3">
                <label class="form-label">Select City</label>
                <select class="form-control city-select" id="citySelect" name="location_id" required>
                    <option value=""></option>
                    <optgroup label="Top Cities">
                        @foreach ($topCities as $data)
                        <option value="{{ $data->id }}"
                            data-city="{{ strtolower(Str::slug($data->name)) }}"
                            {{ isset($property) && $property->location_id == $data->id ? 'selected' : '' }}>
                            {{ $data->name }}
                        </option>
                        @endforeach
                    </optgroup>

                    <optgroup label="Other Cities">
                        @foreach ($otherCities as $data)
                        <option value="{{ $data->id }}"
                            data-city="{{ strtolower(Str::slug($data->name)) }}"
                            {{ isset($property) && $property->location_id == $data->id ? 'selected' : '' }}>
                            {{ $data->name }}
                        </option>
                        @endforeach
                    </optgroup>
                </select>
            </div>
            <br>
            <div id="additionalFields" style="display: none;">
                <div class="mb-3 position-relative">
                    <label class="form-label">Building / Apartment / Society Name (Mandatory)</label>
                    <input type="text" class="form-control" name="building"
                        value="{{ isset($property->building) ? $property->building : '' }}" required autocomplete="off">
                </div>
                <div class="mb-3 position-relative" id="localityGroup">
                    <label class="form-label">Locality / Sector (Mandatory)</label>
                    <input type="text" class="form-control" id="localityInput" name="locality" readonly autocomplete="off"
                        value="{{ isset($property->locality) ? $property->locality : '' }}">
                    <div id="localitySuggestionContainer" style="position:absolute; left:0; right:0; z-index:1000;"></div>
                </div>
                <div class="mb-3" id="sublocalityGroup">
                    <label class="form-label">Sublocality / Area / Street (Optional)</label>
                    <input type="text" class="form-control" id="sublocalityInput" name="sub_locality" readonly autocomplete="off"
                        value="{{ isset($property->sub_locality) ? $property->sub_locality : '' }}">
                </div>
            </div>
            <div class="d-flex justify-content-center mt-3 my-3">
                <a href="{{ url()->previous() }}" id="back-btn"
                    class="btn btn-secondary w-25">{{ __('Back') }}</a>
                <button type="button" onclick="document.getElementById('addressForm').submit();" id="submit-btn"
                    class="btn btn-primary w-25 mx-2">{{ __('Save & Next') }}</button>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key={{ config('app.google_map_api') }}&libraries=places"></script>
<script>
    $(document).ready(function() {
        $('.city-select').select2({
            placeholder: "Select city",
            allowClear: true,
            width: '100%'
        });

        const citySelect = document.getElementById('citySelect');
        const additionalFields = document.getElementById('additionalFields');
        const buildingInput = document.querySelector('[name="building"]');
        const localityInput = document.getElementById('localityInput');
        const sublocalityInput = document.getElementById('sublocalityInput');
       

        let suggestionSelected = false;

        // 👉 This function you already call when suggestion is clicked
        function handleSuggestionSelection(building, locality, sublocality) {
            suggestionSelected = true;

            buildingInput.value = building || "";
            localityInput.value = locality || "";
            sublocalityInput.value = sublocality || "";

            localityInput.setAttribute("readonly", true);
            sublocalityInput.setAttribute("readonly", true);
        }

        // 👉 When user starts typing manually
        buildingInput.addEventListener("input", function() {
            suggestionSelected = false;

            // Clear values while typing
            localityInput.value = "";
            sublocalityInput.value = "";

            localityInput.setAttribute("readonly", true);
            sublocalityInput.setAttribute("readonly", true);
        });

        // 👉 When user leaves building input without selecting suggestion
        buildingInput.addEventListener("blur", function() {
            if (!suggestionSelected && buildingInput.value.trim() !== "") {
                // Unlock manual entry
                localityInput.removeAttribute("readonly");
                sublocalityInput.removeAttribute("readonly");
            }
        });

        let geocoder;
        let autocompleteBuilding;
        let autocompleteLocality;

        function initializeMapServices() {
            if (!geocoder) {
                geocoder = new google.maps.Geocoder();
            }

            // --- Building Autocomplete ---
            if (!autocompleteBuilding) {
                autocompleteBuilding = new google.maps.places.Autocomplete(buildingInput, {
                    types: ['establishment'],
                    componentRestrictions: {
                        country: 'in'
                    }
                });

                autocompleteBuilding.addListener('place_changed', function() {
                    const place = autocompleteBuilding.getPlace();
                    if (!place || !place.address_components) return;

                    // Building name
                    buildingInput.value = place.name ? place.name.split(",")[0] : '';

                    // Reset fields
                    localityInput.value = '';
                    sublocalityInput.value = '';

                    let city = '';
                    let sector = '';
                    let area = '';

                    place.address_components.forEach(component => {
                        if (component.types.includes("locality")) {
                            city = component.long_name;
                        }
                        if (component.types.includes("sublocality_level_1")) {
                            sector = component.long_name;
                        }
                        if (component.types.includes("sublocality_level_2") || component.types.includes("neighborhood")) {
                            area = component.long_name;
                        }
                    });

                    // Fill locality / sublocality
                    localityInput.value = sector || area || '';
                    sublocalityInput.value = area || '';
                });
            }

            // --- Locality Autocomplete ---
            if (!autocompleteLocality) {
                autocompleteLocality = new google.maps.places.Autocomplete(localityInput, {
                    types: ['(regions)'],
                    componentRestrictions: {
                        country: 'in'
                    }
                });

                autocompleteLocality.addListener('place_changed', function() {
                    const place = autocompleteLocality.getPlace();
                    if (!place || !place.address_components) return;

                    let valid = false;
                    let locality = '';
                    let area = '';

                    place.address_components.forEach(component => {
                        if (component.types.includes("sublocality_level_1")) {
                            locality = component.long_name;
                            valid = true;
                        }
                        if (component.types.includes("sublocality_level_2") || component.types.includes("neighborhood")) {
                            area = component.long_name;
                            valid = true;
                        }
                    });

                    if (valid) {
                        localityInput.value = locality || area;
                    } else {
                        localityInput.value = '';
                        alert("Please select a valid locality/sector.");
                    }
                });
            }
        }

        function updateAutocompleteBounds() {
            const selectedCity = citySelect.options[citySelect.selectedIndex].text;
            if (selectedCity && geocoder) {
                geocoder.geocode({
                    address: selectedCity
                }, function(results, status) {
                    if (status === google.maps.GeocoderStatus.OK && results[0]) {
                        const newBounds = results[0].geometry.viewport;

                        // ✅ Restrict autocomplete to the selected city
                        if (autocompleteBuilding) {
                            autocompleteBuilding.setBounds(newBounds);
                            autocompleteBuilding.setOptions({
                                strictBounds: true
                            });
                        }
                        if (autocompleteLocality) {
                            autocompleteLocality.setBounds(newBounds);
                            autocompleteLocality.setOptions({
                                strictBounds: true
                            });
                        }
                    }
                });
            }
        }

        // Page load
        const isEditMode = "{{ isset($property->location_id) ? true : false }}";
        if (isEditMode) {
            additionalFields.style.display = 'block';
            initializeMapServices();
            updateAutocompleteBounds();
        } else {
            additionalFields.style.display = 'none';
            initializeMapServices();
        }

        // City change
        $('#citySelect').on('change', function() {
            if (this.value) {
                additionalFields.style.display = 'block';
                updateAutocompleteBounds();
            } else {
                additionalFields.style.display = 'none';
            }
        });
    });
</script>

@endsection